%This code produces Figure 5 from paper:
%LJ. Stankovic, and M. Brajovic, "Analysis of the Reconstruction of Sparse 
%Signals in the DCT Domain Applied to Audio Signals," IEEE/ACM Transactions on Audio, Speech, and Language Processing, 
%vol. 26, no.7, July 2018, pp.1216-1231, DOI: 10.1109/TASLP.2018.2819819

%If you use this program, please cite the above paper.

clear all
close all 

Calculate=1; % To run the experiment use Calculate=1; For figures only, use Calculate=0

if Calculate==1 
    load('mtlb'), %Loads built-in audio signal from MATLAB, being a 
    %low-quality audio recording of a female voice saying the word "matlab", with the sampling frequency 7418Hz
    mtlb=[zeros(250,1);mtlb;zeros(250,1)]; %zero padding of the original signal
    Mstep=1; Mstart=1; Wwidth=500; Imax=17; 
                % Mstep: Time step for the signal (signal downsampling)
                % Mstart: Starting time instant for the windowed DCT calculation
                % Wwidth: Width  of the window for the DCT calculation
                % Imax: Number of the windowed DCT calculated with step
                % Wwidth/2
    myRecording=mtlb;
    
    pp=randperm(length(myRecording),round(length(myRecording)/10)); %random positions of impulsive disturbances
    
    myRecording(pp)=(3.5+1*rand(size(pp))).*(sign(rand(size(pp))-0.5)); %add the impulsive noise (clicks)

    
    MSE_E_SR=[];
    MSE_T_SR=[];
    
    x_rec=zeros(size(mtlb));
    
    for iwin=1:Imax %for each window, repeat
        M=Mstart+Wwidth*(iwin-1)/2; N=M+Wwidth-1;
        Q2=find(abs(myRecording(M:Mstep:N))>=0.7*max(abs((myRecording))));  % positions of corrupted (non-available) samples
                                                                            % detected by a limiter at 70% of maximal value
        Q1=setdiff([1:Wwidth]',Q2);                                         % positions of non-corrupted (available) samples                                                              
       
        myRecording1=myRecording(M:Mstep:N);
        myRecording1(Q2)=0;
                
        DDZ=dct(hanning(length(myRecording(M:Mstep:N))).*myRecording1); % windowing the corrupted signal part
        DDZorig=dct(hanning(length(mtlb(M:Mstep:N))).*mtlb(M:Mstep:N)); % windowing the original signal part for the theoretical error calculation
        
        MM1=M;
        NN1=N;
        
        figure(5)
        stem(DDZ)
        pause(1)
   
        MSE=mean((idct(DDZ)-mtlb(M:Mstep:N)).^2);
        
        SNR=10*log10(mean((mtlb(M:Mstep:N)).^2)/mean((idct(DDZ)-mtlb(M:Mstep:N)).^2));
        
        MSE_E=[];
        MSE_T=[];
        
        N=length(DDZ);
        W =dctmtx(N);
       
        sigman=3e-3;
        
        Ma=length(Q1);
        Wi=inv(W);
        sigref=idct(DDZ);
        
        KKV=[5:10:150];  % Various assumed sparsity values for the reconstruction
        
        for KK=KKV
            mse_e=[];
            mse_t=[];
            for ii=1:1
                signal=hanning(length(myRecording(MM1:Mstep:NN1))).*myRecording1;
                       
                %The reconstruction algorithm
                Acs=Wi(Q1,:);  % Measurement matrix
                C=dct(signal); % Initial estimate
                ycs=Acs*C;     % Measurements/available samples
                yc=zeros(size(signal));
                yc(Q1)=ycs;
                K=[];
                yr=ycs;
                e=ycs;
                iter=1;
                while length(K)<KK
                    
                    iter=iter+1;
                    Xc=Acs'*e;
                    [mmm,kk]=max(abs(Xc));
                    K=union(K,kk);
                    Ak=Acs(:,K);
                    Xk=(Ak)\ycs;
                    yk=Ak*Xk;
                    e=ycs-yk;
                end
                X=zeros(size(yc));
                X(K)=Xk;              
                Cr=X; %DCT coefficients of the reconstructed signal part
                %end of the reconsruction procedure
                
                qq=1:N;
                qq(K)=[];
                E_teor=KK*((N-Ma)/(Ma*(N-1))*sum(abs(DDZorig(qq)).^2)+(N/Ma)*sigman^2);
               
                MSE_rec2=(sum(abs(X(K)-DDZorig(K)).^2));
                
                mse_t=[mse_t,(E_teor+sum(abs(DDZorig(qq)).^2))/sum(DDZorig.^2)]; %theoretical error
                mse_e=[mse_e,(MSE_rec2+sum(abs(DDZorig(qq)).^2))/sum(DDZorig.^2)]; %numerical error
                
                %
            end
            MSE_E=[ MSE_E,10*log10((mean(mse_e)))];
            MSE_T=[ MSE_T,10*log10((mean(mse_t)))];
        end
        
        x_rec(MM1:Mstep:NN1)=x_rec(MM1:Mstep:NN1)+idct(X); %form the resulting signal based on the reconstructed windowed parts
        
        figure(3)
        plot(KKV,MSE_E,'r*'), title('total error in signal')
        hold on
        plot(KKV,MSE_T)
        grid on
        hold off
        
        MSE_E_SR=[MSE_E_SR; MSE_E];
        MSE_T_SR=[MSE_T_SR; MSE_T];

        
    end
    
    save data_CS
end

    
    %The following part of the program loads the data and forms Figure 5.
    %SetFigureDefaults is an auxiliar
    %function used for the figure formatting
    load data_CS
    close all
    figure
    plot(KKV,mean(MSE_E_SR),'r*'), title('total error in signal')
    hold on
    plot(KKV,mean(MSE_T_SR))
    grid on
    hold off
    
    figure(10)
    SetFigureDefaults(7.9,16)
    subplot(6,1,1)
    stem(mtlb,'.','MarkerSize',3)
    ylabel('signal')
    axis([0,length(mtlb),-5,5])
    text(0,-7.5,'(a)')
    subplot(6,1,2)
    stem(myRecording,'.','MarkerSize',3)
    ylabel('noisy signal')
    xlabel('time index {\itn}')
    axis([0,length(mtlb),-5,5])
    text(0,-7.5,'(b)')
    subplot(6,1,5)
    stem(x_rec,'.','MarkerSize',3)
    ylabel('reconstructed signal')
    xlabel('time index {\itn}')
    axis([0,length(mtlb),-5,5])
    text(0,-7.5,'(d)')
    subplot(3,1,2)
    plot(KKV,mean(MSE_E_SR),'r*',KKV,mean(MSE_T_SR))
    legend('Numerical result','Theory')
    ylabel('total error in signal (dB)')
    xlabel('assumed sparsity {\itK}')
    grid
    set(gca,'XTick',0:10:150)
    text(0,-27.5,'(c)')
     print audio_mtlb -depsc




