function SetFigureDefaults(w,h,fs,fn)
% Figure size, font and axes placement
% Usage:
%       SetFigureDefaults(width,height,fs)
%       width and height in cm fs - font size (pt) 6pt is default
%
if nargin<3
    fs=6;
end
if nargin<4
    fn='Times';
end
sfX=0.75;sfY=0.75;
set(0,'DefaultAxesPosition',[0.15,0.15,sfX,sfY])
set(0,'DefaultAxesFontName',fn)
set(0,'DefaultAxesFontSize',fs)
set(0,'DefaultTextFontName',fn)
set(0,'DefaultTextFontSize',fs)

set(gcf,'PaperUnits','centimeters','Units','Centimeters')
p1=get(gcf,'Position');
p2=get(gcf,'PaperPosition');
p1(2)=p1(2)+p1(4)-h/sfY;
p1([3,4])=[w/sfX,h/sfY];
p2([3,4])=[w/sfX,h/sfY];
set(gcf,'Position',p1,'PaperPosition',p2)